<?php

declare(strict_types=1);

use App\Bot\TelegramBot;
use App\Core\JsonStorage;

require __DIR__ . '/src/bootstrap.php';

$configPath = __DIR__ . '/config/config.php';
if (!is_file($configPath)) {
    http_response_code(500);
    echo 'Config file not found.';
    exit;
}

$config = require $configPath;

$secret = $config['webhook_secret'] ?? '';
if ($secret !== '') {
    $provided = $_GET['secret'] ?? '';
    if (!is_string($provided) || !hash_equals($secret, $provided)) {
        http_response_code(403);
        echo 'Forbidden';
        exit;
    }
}

$raw = file_get_contents('php://input');
if ($raw === false || $raw === '') {
    http_response_code(400);
    echo 'Empty body';
    exit;
}

$update = json_decode($raw, true);
if (!is_array($update)) {
    http_response_code(400);
    echo 'Invalid JSON';
    exit;
}

$storage = new JsonStorage($config['data_dir']);
$bot = new TelegramBot($config, $storage);
$bot->handleUpdate($update);

echo 'OK';
